<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDoctypesTable extends Migration {

	public function up()
	{
		Schema::create('doctypes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->enum('type', array('sales', 'purchase'));
			$table->integer('nextdocnumber');
			$table->string('prefix');
			$table->integer('forwardto');
			$table->boolean('archiveonsafe')->default(false);
			$table->boolean('amount_delivered')->nullable();
			$table->boolean('amount_billed');
		});
	}

	public function down()
	{
		Schema::drop('doctypes');
	}
}