<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderOffersTable extends Migration {

	public function up()
	{
		Schema::create('order_offers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('provider_id')->unsigned();
			$table->double('price')->nullable();
			$table->integer('status')->nullable()->default('0');
			$table->string('notes')->nullable();
			$table->integer('period')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('order_offers');
	}
}