<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemsTable extends Migration {

	public function up()
	{
		Schema::create('items', function(Blueprint $table) {
			$table->increments('item_id');
			$table->string('asset_tag', 10);
			$table->string('serial_number', 20);
			$table->enum('status', array('val1', 'val2', 'etc.'));
			$table->boolean('testing_status');
			$table->timestamps();
			$table->integer('department_id')->unsigned();
			$table->integer('part_number_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('items');
	}
}