<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('users')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('role_id')->references('role_id')->on('roles')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->foreign('company_id')->references('company_id')->on('companies')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->foreign('department_id')->references('department_id')->on('departments')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->foreign('part_number_id')->references('part_number_id')->on('part_numbers')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('request_id')->references('request_id')->on('requests')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('booking_item', function(Blueprint $table) {
			$table->foreign('booking_id')->references('booking_id')->on('bookings')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('booking_item', function(Blueprint $table) {
			$table->foreign('item_id')->references('item_id')->on('items')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('users')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->foreign('contact_id')->references('contact_id')->on('contacts')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->foreign('end_user')->references('company_id')->on('companies')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('part_number_request', function(Blueprint $table) {
			$table->foreign('request_id')->references('request_id')->on('requests')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('part_number_request', function(Blueprint $table) {
			$table->foreign('part_number_id')->references('part_number_id')->on('part_numbers')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->foreign('department_id')->references('department_id')->on('departments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_user_id_foreign');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_role_id_foreign');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->dropForeign('contacts_company_id_foreign');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->dropForeign('items_department_id_foreign');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->dropForeign('items_part_number_id_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_request_id_foreign');
		});
		Schema::table('booking_item', function(Blueprint $table) {
			$table->dropForeign('booking_item_booking_id_foreign');
		});
		Schema::table('booking_item', function(Blueprint $table) {
			$table->dropForeign('booking_item_item_id_foreign');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->dropForeign('requests_user_id_foreign');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->dropForeign('requests_contact_id_foreign');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->dropForeign('requests_end_user_foreign');
		});
		Schema::table('part_number_request', function(Blueprint $table) {
			$table->dropForeign('part_number_request_request_id_foreign');
		});
		Schema::table('part_number_request', function(Blueprint $table) {
			$table->dropForeign('part_number_request_part_number_id_foreign');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->dropForeign('stocks_department_id_foreign');
		});
	}
}