<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDonationRequestTable extends Migration {

	public function up()
	{
		Schema::create('donation_request', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('age');
			$table->bigInteger('blood_type_id')->unsigned();
			$table->decimal('longitude');
			$table->decimal('latitude');
			$table->bigInteger('governorate_id')->unsigned();
			$table->bigInteger('city_id')->unsigned();
			$table->string('phone');
			$table->text('notes');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('donation_request');
	}
}