<?php

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	public function bloodType()
	{
		return $this->belongsTo('BloodType', 'blood_type_id');
	}

	public function city()
	{
		return $this->belongsTo('Citiy', 'city_id');
	}

	public function posts()
	{
		return $this->belongsToMany('Post_user');
	}

	public function contact_us()
	{
		return $this->hasMany('Contact_us', 'user_id');
	}

	public function notifications()
	{
		return $this->belongsToMany('Notification_user', 'user_id');
	}

}