<?php

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	public function bloodType()
	{
		return $this->belongsToMany('BloodType', 'blood_type_id');
	}

	public function city()
	{
		return $this->belongsTo('Citiy', 'city_id');
	}

	public function posts()
	{
		return $this->belongsToMany('Post');
	}

	public function contact_us()
	{
		return $this->belongsTo('Contact_us', 'user_id');
	}

	public function notifications()
	{
		return $this->belongsTo('Notifications');
	}

	public function governorate()
	{
		return $this->belongsToMany('Governorate', 'governorate_id');
	}

	public function donation_request()
	{
		return $this->belongsTo('Donation_requests', 'donation_request_id');
	}

}