<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployeesTable extends Migration {

	public function up()
	{
		Schema::create('employees', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->string('country_code', 10);
			$table->string('phone', 100);
			$table->text('permissions');
			$table->string('code', 10);
			$table->integer('provider_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('employees');
	}
}