<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('amount');
			$table->string('duration', 100);
			$table->integer('pay_type_id')->default('0');
			$table->string('salary', 150);
			$table->string('salary_source_id', 255);
			$table->boolean('has_work')->default(0);
			$table->string('work_name', 255);
			$table->string('work_location', 255);
			$table->string('current_work', 255);
			$table->integer('home_status')->default('0');
			$table->boolean('others_commitments')->default(0);
			$table->string('others_commitments_amount', 150);
			$table->integer('family_count');
			$table->boolean('has_government_support')->default(0);
			$table->string('government_program', 255);
			$table->text('details');
			$table->string('salary_file', 150);
			$table->string('account_statement', 150);
			$table->string('guarantor_name', 150);
			$table->string('guarantor_identity_id', 255);
			$table->string('guarantor_identity_image', 255);
			$table->integer('user_id')->unsigned();
			$table->string('user_name', 255);
			$table->string('user_phone', 255);
			$table->integer('user_city_id')->unsigned();
			$table->string('user_identity_id', 255);
			$table->string('user_identity_image', 255);
			$table->integer('status')->default('0');
			$table->text('cancel_reason');
			$table->integer('provider_id')->unsigned();
			$table->string('ref_code', 50);
			$table->integer('type')->default('0');
			$table->integer('admin_commission_ratio');
			$table->integer('admin_commission');
			$table->integer('broker_commission_ratio');
			$table->integer('broker_commission');
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}