<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Specialties extends Model 
{

    protected $table = 'specialties';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name');

    public function lawyers()
    {
        return $this->hasMany('LawyersSpecialties', 'speciality_id');
    }

}