<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePayoutsTable extends Migration {

	public function up()
	{
		Schema::create('payouts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('lawyer_id');
			$table->double('amount');
			$table->enum('status', array('processing', 'completed'));
			$table->date('process_date');
		});
	}

	public function down()
	{
		Schema::drop('payouts');
	}
}