<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Messages extends Model 
{

    protected $table = 'messages';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('from_user', 'to_user', 'type', 'message', 'order_id', 'is_reply');

    public function from_user()
    {
        return $this->belongsTo('User', 'from_user');
    }

    public function to_user()
    {
        return $this->belongsTo('User', 'to_user');
    }

    public function order()
    {
        return $this->belongsTo('Orders', 'order_id');
    }

}