<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RatingStars extends Model 
{

    protected $table = 'rating_stars';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('rating_id', 'rate', 'question_id');

    public function rating()
    {
        return $this->belongsTo('Rating', 'rating_id');
    }

    public function question()
    {
        return $this->belongsTo('RatingQuestions', 'question_id');
    }

}