<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Qualifications extends Model 
{

    protected $table = 'qualifications';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('start_at', 'expire_at', 'university', 'faculty', 'specialty', 'degree_id', 'description', 'lawyer_id');

    public function lawyer()
    {
        return $this->belongsTo('Lawyers', 'lawyer_id');
    }

    public function degree()
    {
        return $this->belongsTo('Degrees', 'degree_id');
    }

}