<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Orders extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'lawyer_id', 'category_id', 'specialty_id', 'language_id', 'type', 'title', 'details', 'status', 'offer_id', 'discount_id', 'price');

    public function invitations()
    {
        return $this->hasMany('Invitations', 'order_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function lawyer()
    {
        return $this->belongsTo('Lawyers', 'lawyer_id');
    }

    public function category()
    {
        return $this->belongsTo('Categories', 'category_id');
    }

    public function specialty()
    {
        return $this->belongsTo('Specialties', 'specialty_id');
    }

    public function language()
    {
        return $this->belongsTo('Languages', 'language_id');
    }

    public function offer()
    {
        return $this->belongsTo('Offers', 'offer_id');
    }

    public function offers()
    {
        return $this->hasMany('Offers', 'order_id');
    }

    public function discount()
    {
        return $this->belongsTo('Discounts', 'discount_id');
    }

    public function massages()
    {
        return $this->hasMany('Messages', 'order_id');
    }

}