<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Payouts extends Model 
{

    protected $table = 'payouts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('lawyer_id', 'amount', 'status', 'process_date');

    public function lawyer()
    {
        return $this->belongsTo('Lawyers', 'lawyer_id');
    }

}