<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Rating extends Model 
{

    protected $table = 'rating';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'rating_to', 'order_id', 'rate', 'status');

    public function rating_stars()
    {
        return $this->hasMany('RatingStars', 'rating_id');
    }

    public function comment()
    {
        return $this->hasOne('RatingReviews', 'rating_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function rating_to()
    {
        return $this->belongsTo('User', 'user_id');
    }

}