<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLicensesTable extends Migration {

	public function up()
	{
		Schema::create('licenses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->date('start_at');
			$table->date('expire_at');
			$table->string('license_number');
			$table->enum('type', array('trainer', 'licensed', 'counsel'));
			$table->integer('country_id');
			$table->integer('lawyer_id');
		});
	}

	public function down()
	{
		Schema::drop('licenses');
	}
}