<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMessagesTable extends Migration {

	public function up()
	{
		Schema::create('messages', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('from_user');
			$table->integer('to_user');
			$table->enum('type', array('image', 'text', 'file', ''));
			$table->longText('message');
			$table->integer('order_id');
			$table->boolean('is_reply')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('messages');
	}
}