<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMembershipsTable extends Migration {

	public function up()
	{
		Schema::create('memberships', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('organization');
			$table->date('start_at');
			$table->boolean('still')->default(0);
			$table->date('expire_at')->nullable();
			$table->integer('lawyer_id');
			$table->string('name')->nullable();
			$table->integer('country_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('memberships');
	}
}