<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOffersTable extends Migration {

	public function up()
	{
		Schema::create('offers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('order_id');
			$table->integer('lawyer_id');
			$table->integer('invitation_id');
			$table->double('price');
			$table->integer('period');
			$table->enum('status', array('accept', 'refuse'));
			$table->longText('details');
			$table->text('cancel_reason')->nullable();
			$table->boolean('read')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('offers');
	}
}