<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoursesTable extends Migration {

	public function up()
	{
		Schema::create('courses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->datetime('start_at');
			$table->datetime('expire_at');
			$table->string('institute');
			$table->string('name');
			$table->integer('hours_number')->nullable();
			$table->string('description')->nullable();
			$table->integer('lawyer_id');
		});
	}

	public function down()
	{
		Schema::drop('courses');
	}
}