<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id');
			$table->integer('lawyer_id');
			$table->integer('category_id');
			$table->integer('specialty_id');
			$table->integer('language_id');
			$table->enum('type', array('advice', 'issue'));
			$table->string('title');
			$table->text('details');
			$table->enum('status', array('new', 'waiting_for_reply', 'reply', 'completed', 'draft', 'information_is_required', 'enquiry', 'waiting_for_offers', 'accept_offer', 'refuse_offer', 'cancelled'));
			$table->integer('offer_id')->nullable();
			$table->integer('discount_id')->nullable();
			$table->double('price')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}