<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQualificationsTable extends Migration {

	public function up()
	{
		Schema::create('qualifications', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->date('start_at');
			$table->date('expire_at');
			$table->string('university');
			$table->string('faculty');
			$table->string('specialty');
			$table->integer('degree_id')->nullable();
			$table->string('description')->nullable();
			$table->integer('lawyer_id');
		});
	}

	public function down()
	{
		Schema::drop('qualifications');
	}
}