<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->double('price', 8,2);
			$table->integer('time');
			$table->string('description', 255);
			$table->string('image', 255);
			$table->float('rate');
			$table->float('discount', 0,2);
			$table->integer('category_id')->unsigned();
			$table->integer('restaurant_id')->unsigned();
			$table->string('voucher_code', 255);
			$table->decimal('voucher_discount', 0.2);
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}