<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRestaurantReviewsTable extends Migration {

	public function up()
	{
		Schema::create('restaurant_reviews', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->float('packaging');
			$table->float('money');
			$table->float('delivery_time');
			$table->float('quality_of_food');
			$table->integer('restaurant_id')->unsigned();
			$table->integer('client_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('restaurant_reviews');
	}
}