<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMerchantPlateformConfigsTable extends Migration {

	public function up()
	{
		Schema::create('merchantPlateformConfigs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('merchant_logo', 75);
			$table->string('plateform_primary_color', 50);
			$table->string('plateform_secondary_color', 50)->nullable();
			$table->string('reference_get_url', 255);
			$table->string('reference_list_get_url', 255)->nullable();
			$table->string('notification_url', 255);
			$table->integer('merchant_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('merchantPlateformConfigs');
	}
}