<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->text('description');
			$table->string('status');
			$table->integer('id_user')->unsigned();
			$table->string('banner')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}