<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePrestationsTable extends Migration {

	public function up()
	{
		Schema::create('prestations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_user')->unsigned();
			$table->integer('id_category')->unsigned();
			$table->string('name');
			$table->double('minimu_price');
			$table->integer('id_device');
			$table->string('banner')->nullable();
			$table->string('description');
			$table->string('status');
			$table->integer('view')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('prestations');
	}
}