<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('socials', function(Blueprint $table) {
			$table->foreign('id_user')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_details', function(Blueprint $table) {
			$table->foreign('id_user')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('groups', function(Blueprint $table) {
			$table->foreign('id_user')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('throttle', function(Blueprint $table) {
			$table->foreign('id_user')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_group', function(Blueprint $table) {
			$table->foreign('id_user')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_group', function(Blueprint $table) {
			$table->foreign('id_group')->references('id')->on('groups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('shops', function(Blueprint $table) {
			$table->foreign('id_user')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('shops', function(Blueprint $table) {
			$table->foreign('id_category')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('id_user')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('prestations', function(Blueprint $table) {
			$table->foreign('id_user')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('prestations', function(Blueprint $table) {
			$table->foreign('id_category')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('certifications', function(Blueprint $table) {
			$table->foreign('id_user')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('groupes', function(Blueprint $table) {
			$table->foreign('id_user')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->foreign('id_group')->references('id')->on('groupes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->foreign('id_user')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('id_user')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('id_post')->references('id')->on('posts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('socials', function(Blueprint $table) {
			$table->dropForeign('socials_id_user_foreign');
		});
		Schema::table('user_details', function(Blueprint $table) {
			$table->dropForeign('user_details_id_user_foreign');
		});
		Schema::table('groups', function(Blueprint $table) {
			$table->dropForeign('groups_id_user_foreign');
		});
		Schema::table('throttle', function(Blueprint $table) {
			$table->dropForeign('throttle_id_user_foreign');
		});
		Schema::table('user_group', function(Blueprint $table) {
			$table->dropForeign('user_group_id_user_foreign');
		});
		Schema::table('user_group', function(Blueprint $table) {
			$table->dropForeign('user_group_id_group_foreign');
		});
		Schema::table('shops', function(Blueprint $table) {
			$table->dropForeign('shops_id_user_foreign');
		});
		Schema::table('shops', function(Blueprint $table) {
			$table->dropForeign('shops_id_category_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_id_user_foreign');
		});
		Schema::table('prestations', function(Blueprint $table) {
			$table->dropForeign('prestations_id_user_foreign');
		});
		Schema::table('prestations', function(Blueprint $table) {
			$table->dropForeign('prestations_id_category_foreign');
		});
		Schema::table('certifications', function(Blueprint $table) {
			$table->dropForeign('certifications_id_user_foreign');
		});
		Schema::table('groupes', function(Blueprint $table) {
			$table->dropForeign('groupes_id_user_foreign');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->dropForeign('posts_id_group_foreign');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->dropForeign('posts_id_user_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_id_user_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_id_post_foreign');
		});
	}
}