<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Certification extends Eloquent {

	protected $table = 'certifications';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('certifiable_id', 'certifiable_type', 'reason', 'status', 'id_user');
	protected $visible = array('certifiable_id', 'certifiable_type', 'reason', 'status', 'id_user');

	public function certifiable()
	{
		return $this->morphTo();
	}

}