<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Groupe extends Eloquent {

	protected $table = 'groupes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'banner', 'description', 'status', 'id_user');
	protected $visible = array('name', 'banner', 'description', 'status', 'id_user');

	public function certifications()
	{
		return $this->morphMany('App\Models\Certification', 'certifiable_id');
	}

	public function posts()
	{
		return $this->hasMany('App\Models\Post', 'id_group');
	}

}