<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class UserDetail extends Eloquent {

	protected $table = 'user_details';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('birth_date', 'first_name', 'last_name', 'state', 'country', 'city', 'gender', 'address', 'avatar', 'description');
	protected $visible = array('id_user', 'birth_date', 'first_name', 'last_name', 'state', 'country', 'city', 'gender', 'address', 'avatar', 'description');

	public function user()
	{
		return $this->belongsTo('App\Models\User', 'id_user');
	}

}