<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDepartmentTypesTable extends Migration {

	public function up()
	{
		Schema::create('department_types', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 64)->nullable()->index();
			$table->string('description', 256)->nullable();
			$table->string('code', 10)->nullable();
			$table->string('acronym', 8)->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('department_types');
	}
}