<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReviewsTable extends Migration {

	public function up()
	{
		Schema::create('reviews', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('facility_id')->unsigned()->index();
			$table->integer('owner_id')->unsigned()->index();
			$table->string('import_id', 64)->nullable();
			$table->string('title', 128);
			$table->string('source', 32)->nullable();
			$table->string('description', 512)->nullable();
			$table->string('import_version', 15)->nullable();
			$table->smallInteger('year')->index();
			$table->smallInteger('month')->index();
		});
	}

	public function down()
	{
		Schema::drop('reviews');
	}
}