<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateToolsTable extends Migration {

	public function up()
	{
		Schema::create('tools', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 64)->nullable()->index();
			$table->string('import_id', 64)->nullable();
			$table->string('description', 256)->nullable()->index();
			$table->string('source', 32)->nullable();
			$table->string('import_version', 15)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tools');
	}
}