<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Owner extends Eloquent {

	protected $table = 'owners';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'acronym', 'owner_type', 'role_type', 'import_id', 'source', 'import_version', 'permissions', 'owner_role');

	public function ownerCategories()
	{
		return $this->hasMany('App\Models\OwnerDefinedCategory');
	}

	public function ownedFacilities()
	{
		return $this->hasMany('App\Models\Facility');
	}

	public function managedFacilities()
	{
		return $this->hasMany('App\Models\Facility');
	}

	public function reviews()
	{
		return $this->hasMany('App\Models\Review');
	}

}