<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Review extends Eloquent {

	protected $table = 'reviews';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('facility_id', 'owner_id', 'title', 'description', 'year', 'month');

	public function reviewAssessments()
	{
		return $this->hasMany('App\Models\ReviewAssessment');
	}

	public function facility()
	{
		return $this->hasOne('App\Models\Facility');
	}

	public function owner()
	{
		return $this->belongsTo('App\Models\Owner');
	}

}