<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTrendTaxiAppPastTripsTable extends Migration {

	public function up()
	{
		Schema::create('trend_taxi_app_past_trips', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('trip_id', 24);
			$table->integer('driver_id')->unsigned()->index();
			$table->integer('passenger_id')->unsigned()->index();
			$table->integer('start_time');
			$table->integer('end_time')->nullable();
			$table->text('locations')->nullable();
			$table->enum('status', array('0', '1', '2', '3', '4', '5', '6', '7', '8', '9'))->index();
			$table->decimal('est_price', 15,2)->nullable()->default('0');
			$table->decimal('est_distance', 15,2);
			$table->string('est_duration', 24)->nullable();
			$table->decimal('act_price', 15,2)->nullable();
			$table->decimal('act_distance', 15,2)->nullable();
			$table->string('act_duration', 24)->nullable();
			$table->decimal('trip_reward', 15,2)->nullable();
			$table->decimal('trip_fee', 15,2)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('trend_taxi_app_past_trips');
	}
}