<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Company extends Eloquent {

	protected $table = 'company';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function products()
	{
		return $this->belongsToMany('Product');
	}

	public function region()
	{
		return $this->belongsTo('Region');
	}

}