<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicePaymentTable extends Migration {

	public function up()
	{
		Schema::create('invoice_payment', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('fund_id')->nullable();
			$table->double('amount')->nullable();
			$table->datetime('paid_at')->nullable();
			$table->text('note')->nullable();
			$table->integer('invoice_id')->nullable();
			$table->integer('user_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('invoice_payment');
	}
}