<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShippingClientTable extends Migration {

	public function up()
	{
		Schema::create('shipping_client', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->nullable();
			$table->integer('shipping_id')->nullable();
			$table->integer('client_id')->nullable();
			$table->double('total')->nullable();
			$table->double('total_after')->nullable();
			$table->integer('total_contents')->nullable();
			$table->double('total_square')->nullable();
			$table->enum('status', array('not_delivered', 'delivered'))->nullable();
			$table->enum('pay_status', array('all', 'part', 'not'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('shipping_client');
	}
}