<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Service extends Model 
{

    protected $table = 'Services';
    public $timestamps = true;

    public function doctors()
    {
        return $this->hasMany('Doctor');
    }

    public function bookings()
    {
        return $this->hasMany('Booking_item');
    }

    public function discount()
    {
        return $this->morphOne('Discount');
    }

    public function service_names()
    {
        return $this->belongsTo('ServiceNames');
    }

}