<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductVariationsTable extends Migration {

	public function up()
	{
		Schema::create('product_variations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('variation_name', 255)->unique();
			$table->integer('product_id')->unsigned();
			$table->float('price', 7,2);
			$table->integer('quantity');
			$table->string('status', 255);
		});
	}

	public function down()
	{
		Schema::drop('product_variations');
	}
}