<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('variation_values', function(Blueprint $table) {
			$table->foreign('variation_id')->references('id')->on('variations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_variations', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_variation_details', function(Blueprint $table) {
			$table->foreign('product_variation_id')->references('id')->on('product_variations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_variation_details', function(Blueprint $table) {
			$table->foreign('variation_value_id')->references('id')->on('variation_values')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('variation_values', function(Blueprint $table) {
			$table->dropForeign('variation_values_variation_id_foreign');
		});
		Schema::table('product_variations', function(Blueprint $table) {
			$table->dropForeign('product_variations_product_id_foreign');
		});
		Schema::table('product_variation_details', function(Blueprint $table) {
			$table->dropForeign('product_variation_details_product_variation_id_foreign');
		});
		Schema::table('product_variation_details', function(Blueprint $table) {
			$table->dropForeign('product_variation_details_variation_value_id_foreign');
		});
	}
}