<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->string('address', 255);
			$table->enum('method_payment', array('cash', 'online'));
			$table->enum('state', array('pending', 'accepted', 'rejected', 'delivered', 'declined'));
			$table->decimal('price');
			$table->integer('client_id')->unsigned();
			$table->integer('restaurant_id')->unsigned();
			$table->decimal('cost');
			$table->decimal('delivery_cost');
			$table->decimal('total');
			$table->decimal('commission');
			$table->decimal('net');
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}