<?php

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'password', 'pin_code', 'phone', 'image', 'district_id');

	public function district()
	{
		return $this->belongsTo('District');
	}

	public function orders()
	{
		return $this->hasMany('Order');
	}

	public function comments()
	{
		return $this->hasMany('\Comment');
	}

	public function notifications()
	{
		return $this->morphMany('Notification', 'notifiable');
	}

	public function tokens()
	{
		return $this->morphMany('Token', 'tokable');
	}

}