<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientDataTable extends Migration {

	public function up()
	{
		Schema::create('client_data', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('category');
			$table->string('type');
			$table->string('title');
			$table->string('description');
			$table->string('start_date');
			$table->string('end_date');
			$table->boolean('is_language');
			$table->bigInteger('user_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('client_data');
	}
}