<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('phrases', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('translations', function(Blueprint $table) {
			$table->foreign('source_phrase_id')->references('id')->on('phrases')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('translations', function(Blueprint $table) {
			$table->foreign('target_phrase_id')->references('id')->on('phrases')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('translations', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('phrases', function(Blueprint $table) {
			$table->dropForeign('phrases_language_id_foreign');
		});
		Schema::table('translations', function(Blueprint $table) {
			$table->dropForeign('translations_source_phrase_id_foreign');
		});
		Schema::table('translations', function(Blueprint $table) {
			$table->dropForeign('translations_target_phrase_id_foreign');
		});
		Schema::table('translations', function(Blueprint $table) {
			$table->dropForeign('translations_category_id_foreign');
		});
	}
}