<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdvertisementsTable extends Migration {

	public function up()
	{
		Schema::create('advertisements', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('image');
			$table->enum('size', array('large', 'small'));
			$table->bigInteger('site_language_id')->unsigned();
			$table->bigInteger('country_id')->unsigned();
			$table->bigInteger('advertisement_category_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('advertisements');
	}
}